<div id="help" lcass="wrap">

    <h1><?php echo esc_html__( 'Help', 'addonpayments' ); ?></h1>
    <!-- Manual -->
    <div class="card">
          <h2><?php echo esc_html__( 'Documentation', 'addonpayments' ); ?></h2>
        <p>
		    <?php printf( esc_html__( 'You can download the plugin documentation by clicking %s here %s', 'addonpayments' ),
			    '<a target="_blank" href="https://docs.globalpayments.es/wp-content/uploads/2023/02/Addon-Payments-Modulo-de-pago-WooCommerce.pdf">',
                '</a>'
            ) ?>
        </p>
    </div>

    <!-- Help -->
    <div class="card">
        <h2><?php echo esc_html__( 'Configuration', 'addonpayments' ); ?></h2>
        <table>
            <tbody>
            <tr>
                <td><?php echo esc_html__( 'Live mode', 'addonpayments' ); ?></td>
                <td><?php echo esc_html__( 'Set this switch to no to test the gateway', 'addonpayments' ); ?></td>
            </tr>
            <tr>
                <td><?php echo esc_html__( 'Merchant ID, API Key, Password and Product ID', 'addonpayments' ); ?></td>
                <td><?php echo esc_html__( 'Values provided by ESG', 'addonpayments' ); ?></td>
            </tr>
            </tbody>
        </table>

    </div>

    <!-- Test cards -->
    <div class="card">
        <h2><?php echo esc_html__( 'Test cards', 'addonpayments' ); ?></h2>
        <p>
			<?php
			echo sprintf(
				esc_html__(
					'You can get information about test cards from %1$s this link %2$s',
					'addonpayments'
				),
				'<a href="https://api-developer.easypaymentgateway.com/js/js_cards/js_cards_authorization/use_cases_api#section/Test-Cards-and-Wild-Data/3DS-and-Authorization" target="_blank">',
				'</a>'
			);
			?>
        </p>
    </div>

    <!-- Refund info -->
    <div class="card">
        <h2><?php echo esc_html__( 'Refunds', 'addonpayments' ); ?></h2>

        <div>
            <p>
				<?php
				echo esc_html__(
					'If the order has been paid you can use the refund button inside the order to issue a refund',
					'addonpayments'
				)
				?>
            </p>
            <p>
				<?php
				echo esc_html__(
					'If the order is pending of being captured you can change the status from On hold to cancelled to void the payment',
					'addonpayments'
				)
				?>
            </p>
        </div>
        <div>
            <div></div>
            <!-- <img src="{$module_dir|escape:'html':'UTF-8'}views/img/refunds.png" class="col-xs-3 col-md-2 text-center"/> -->
        </div>
    </div>

    <!-- BO transactions -->
    <div class="card">
        <h2><?php echo esc_html__( 'Transactions', 'addonpayments' ); ?></h2>

        <div>
            <p>
				<?php
				echo esc_html__(
						'To get the details of a transaction in the EPG backoffice you have to go to Monitoring > Transaction Search.',
						'addonpayments'
					);
				?>
            </p>
        </div>

        <div>
            <div></div>
            <!-- <img src="{$module_dir|escape:'html':'UTF-8'}views/img/transactions_search.png"
				 class="col-xs-6 col-md-10 text-center"/> -->
            <div></div>
        </div>

        <div>
            <p>
				<?php
				echo esc_html__(
					'And there use the search form to look for your transaction, then double-click on your desired transaction',
					'addonpayments'
				)
				?>
            </p>
        </div>
    </div>

	<?php if ( $is_configured ) : ?>
        <div class="card">
            <h2><?php echo esc_html__( 'Endpoint status', 'addonpayments' ); ?></h2>
            <table>
                <tbody>
                <tr>
                    <td><?php echo esc_html__( 'Web API', 'addonpayments' ); ?></td>
                    <td>
						<?php
						if ( $hc_web_api ) {
							echo esc_html__( 'Working', 'addonpayments' );
						} else {
							echo esc_html__( 'Not working', 'addonpayments' );
						}
						?>
                    </td>
                </tr>
                <tr>
                    <td><?php echo esc_html__( 'Payment form', 'addonpayments' ); ?></td>
                    <td>
						<?php
						if ( $hc_js_library ) {
							echo esc_html__( 'Working', 'addonpayments' );
						} else {
							echo esc_html__( 'Not working', 'addonpayments' );
						}
						?>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
	<?php endif; ?>
</div>
