<?php
/**
 * Help page for Addonpayments module
 *
 * @package Addonpayments
 */

namespace WooCommerce\Plugin\AddonPayments;

/**
 * Info Page Class
 */
class InfoPage {

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'admin_menu', array( $this, 'add_info_page' ), 99 );
		add_filter( 'plugin_action_links', array( $this, 'info_page_action_links' ), 10, 2 );
	}

	/**
	 * Adds info page
	 *
	 * @return void
	 */
	public function add_info_page() {
		add_submenu_page(
			null,
			'Info',
			'Info',
			'manage_options',
			'info-page',
			array( $this, 'get_content' )
		);
	}

	/**
	 * Loads info page template and data
	 *
	 * @return void
	 */
	public function get_content() {
		$payment_gateways = \WC_Payment_Gateways::instance();
		$payment_gateway  = $payment_gateways->payment_gateways()[ ID_EPG ];
		$back_office_link = $payment_gateway->getBackOfficeLink();
		$is_configured    = $payment_gateway->is_configured();
		$hc_web_api       = '';

		if ( ! empty( $payment_gateway->settings['merchant_id'] ) ) {
			$hc_web_api = $payment_gateway->hc_web_api();
		}

		$hc_js_library = $payment_gateway->hc_js_library();
//		$help_link     = get_site_url(
//			null,
//			'/wp-content/plugins/addonpayments/assets/Woocommerce-ManualUsuario.pdf'
//		);

		require_once EPG_BASE_DIR . '/templates/info-page.php';
	}

	/**
	 * Create help link for plugins page
	 *
	 * @param array  $links Plugin actions.
	 * @param string $file Plugin file.
	 *
	 * @return array
	 */
	public function info_page_action_links( $links, $file ) {
		if ( EPG_PLUGIN_NAME === $file ) {
			$links['help'] = '<a href="' . get_bloginfo( 'wpurl' ) . '/wp-admin/admin.php?page=info-page">' . __(
				'Help',
				'addonpayments'
			) . '</a>';
		}

		return $links;
	}
}
