<?php

namespace WooCommerce\Plugin\AddonPayments\Operations;

use ComerciaGlobalPayments\AddonPayments\SDK\Request\Capture;
use WooCommerce\Plugin\AddonPayments\Entities\Transaction;

class CaptureTransaction {

	public function __invoke( $transactionId ) {
		$transaction      = Transaction::getByPayFrexTransactionId( $transactionId )[0];
		$order            = wc_get_order( $transaction->id_order );
		$payment_gateways = \WC_Payment_Gateways::instance();
		$payment_gateway  = $payment_gateways->payment_gateways()[ ID_EPG ];
		$apiClient        = $payment_gateway->getApiClient();

		$request  = ( new Capture() )
			->setTransactionId( $transaction->payFrexTransactionId )
//			->setTransactionId( 7542097 )
			->setMerchantTransactionId( $transaction->merchantTransactionId )
			->setPaymentSolution( $transaction->paymentSolution )
			->setDescription(
				sprintf(
					__( 'Capture transaction %1$s for order %2$s', 'addonpayments' ),
					$transactionId,
					$transaction->id_order
				)
			)
			->setMerchantParams(
				array(
					'reference' => $transaction->id_order,
					'customer'  => $order->get_customer_id(),
					'operation' => 'capture',
				)
			);

		return $apiClient->capture( $request );

	}
}