<?php
/**
 * Class AP_Config file.
 */
class AP_Config {

	// Default configuration - Payment title and logo
    public const DEFAULT_CONFIGURATION = 'default_config';

    public const DEFAULT_OPTION_CREDIT_CARD = 'credit_card';

    public const DEFAULT_OPTION_CREDIT_CARD_BIZUM = 'credit_card_bizum';

    public const DEFAULT_OPTION_QUIX = 'quix';

    public const DEFAULT_OPTION_MULTIPLE = 'multiple';

    public const DEFAULT_OPTION_GLOBALPAYMENTS = 'globalpayments';

    public const DEFAULT_OPTION_CUSTOM = 'custom';

	public static function getDefaultPaymentConfig()
    {
        return [
            self::DEFAULT_OPTION_CREDIT_CARD => __('Credit Card', 'addonpayments'),
            self::DEFAULT_OPTION_CREDIT_CARD_BIZUM => __('Credit Card or Bizum', 'addonpayments'),
            self::DEFAULT_OPTION_QUIX => __('Pay in instalments', 'addonpayments'),
            self::DEFAULT_OPTION_MULTIPLE => __('Select your payment method', 'addonpayments'),
            self::DEFAULT_OPTION_GLOBALPAYMENTS => __('Select your payment method', 'addonpayments'),
            self::DEFAULT_OPTION_CUSTOM => __('Custom', 'addonpayments'),
        ];
    }

	/**
	 * @return string
	 */
	public static function getDefaultLogoUri() {
		return plugins_url( 'assets' . DIRECTORY_SEPARATOR . 'img' . DIRECTORY_SEPARATOR  . 'default-config'
		                    . DIRECTORY_SEPARATOR, ADDONPAYMENTS_PLUGIN_FILE );
	}

	    /**
     * @param $payment_option
     *
     * @return string
     */
    public static function getDefaultTitle($payment_option)
    {
        return self::getDefaultPaymentConfig()[$payment_option];
    }

}