<?php

// @TODO: Validate fields

use ComerciaGlobalPayments\AddonPayments\SDK\Encryption\Cypher\Aes256Ecb;
use ComerciaGlobalPayments\AddonPayments\SDK\Response\OperationInterface;
use ComerciaGlobalPayments\AddonPayments\SDK\Response\Transaction;
use Hashids\Hashids;
use WooCommerce\Plugin\AddonPayments\Operations\ProcessTransaction;
use WooCommerce\Plugin\AddonPayments\Operations\ValidateOrder;

global $wp_filesystem;

$payment_gateways = \WC_Payment_Gateways::instance();
$payment_gateway  = $payment_gateways->payment_gateways()[ ID_EPG ];

$cypher       = new Aes256Ecb();
$payment_hash = $epg_confirmation;

$hashids                 = new Hashids( SECURE_AUTH_SALT );
[ $order_id, $trx ] = $hashids->decode( $payment_hash );

$order = new WC_Order( $order_id );

$payload = file_get_contents( 'php://input' );
$payload = preg_replace( array( '/\n/', '/\t/', '/' . PHP_EOL . '/' ), '', $payload );

if ( wp_is_json_request() ) {
	$payload = json_decode( $payload, false );
} else {
	$payload = json_decode( json_encode( simplexml_load_string( $payload ) ), false );
}

$transactions = array();
$n_operations = count( $payload->operations );

$operations = isset( $payload->{OperationInterface::RESPONSE_OPERATIONS_KEY} ) ?
	OperationInterface::RESPONSE_OPERATIONS_KEY :
	OperationInterface::RESPONSE_OPERATIONS_ARRAY_KEY;

if ( is_object( $payload->{$operations} ) &&
	 is_array( $payload->{$operations}->operation ) ) {
	$payload->{$operations} = $payload->{$operations}->operation;
}

if ( empty( $payload->{$operations} ) ) {
	throw new Exception( 'The request does not contain any operations.' );
}

foreach ( $payload->operations as $operation ) {
	$transaction = new Transaction( $operation );

	( new ProcessTransaction() )( $transaction, $n_operations, $order_id );
	$transactions[] = $transaction;
}

$payload_status = $payload->status;

switch ( $payload_status ) {
	case OperationInterface::STATUS_SUCCESS:
		try {
			( new ValidateOrder() )( $transactions, $order );

		} catch ( Exception $e ) {
			throw new Exception( $e->getMessage() );
		}
		break;

	case OperationInterface::STATUS_ERROR:
	case OperationInterface::STATUS_FAIL:
		$message = $payload->message ?: __( 'Payment failed', 'addonpayments' );
		$order->update_status( 'wc-failed', $message );

		wc_add_notice( $message, 'error' );
		WC()->session->set( 'reload_checkout', true );

		break;

	case OperationInterface::STATUS_CANCELLED:
		$message = $payload->message ?:
			__( 'Payment canceled by user', 'addonpayments' );

		if ( ! empty( $payload->message ) ) {
			$message = $payload->message;
		}

		$order->update_status( 'wc-cancelled', $message );
		wc_add_notice( $message, 'error' );

		WC()->session->set( 'reload_checkout', true );

		break;
}

header( 'Expires: Mon, 26 Jul 1997 05:00:00 GMT' );
header( 'Last-Modified: ' . gmdate( 'D, d M Y H:i:s' ) . ' GMT' );

header( 'Cache-Control: no-store, no-cache, must-revalidate' );
header( 'Cache-Control: post-check=0, pre-check=0', false );
header( 'Pragma: no-cache' );

header( 'HTTP/1.0 200 Success' );
die();
