( function ($) {

  const body = $('body')

  const defaultConfiguration = {
    init: function () {
      this.config()

      this.$defaultConfigSelect.on('change', this.setConfig.bind(this))
      this.$titleField.on('change', this.saveTitle.bind(this))

      this.$inputFile.on('change', this.addImage.bind(this))
      this.$buttonRemove.on('click', this.removeImage.bind(this))

      this.$buttonAdd.add(this.$inputFilename).on('click',  (e) => {
        e.preventDefault()
        this.$inputFile.click()
      });

    },
    config: function () {
      this.$form                = body.find('#mainform')
      this.$defaultConfigSelect = this.$form.find('#woocommerce_addonpayments_default_config')
      this.$defaultFields       = this.$form.find('.default-config')
      this.$titleField          = this.$form.find('#woocommerce_addonpayments_title')

      this.$imageFileWrapper = this.$form.find('.addonpayments-icon-file-wrapper')
      this.$image            = this.$form.find('#addonpayments-icon-image')
      this.$imageDescription = this.$form.find('#addonpayments-icon-fieldset .description span')
      this.$inputFilename    = this.$imageFileWrapper.find('#addonpayments-icon-filename')
      this.$inputFile        = this.$imageFileWrapper.find('#addonpayments-icon-file')
      this.$buttonAdd        = this.$imageFileWrapper.find('#addonpayments-icon-add')
      this.$buttonRemove     = this.$imageFileWrapper.find('#addonpayments-icon-remove')
    },
    setConfig: function (e) {
      var $select = $(e.target)
      const value = $select.val()

      if ('' !== value) {

        if ('custom' !== value) {
          this.$titleField.val(apConfig[value])
          this.$titleField.attr('readonly', true)
          this.$imageFileWrapper.addClass('hidden')
          this.$imageDescription.addClass('hidden')
          this.$image.attr('src', apConfig.image_uri + value + '.png')
        }
        else {
          this.setCustomTitle()
          this.setCustomImage()

          this.$titleField.attr('readonly', false)
          this.$imageFileWrapper.removeClass('hidden')
          this.$imageDescription.removeClass('hidden')
        }

        this.$defaultFields.removeClass('hidden')

      }
      else {
        this.$defaultFields.addClass('hidden')
      }
    },
    saveTitle: function (e) {
      this.customTitle = e.currentTarget.value
    },
    setCustomTitle: function () {
      console.log()
      if (undefined !== this.customTitle) {
        this.$titleField.val(this.customTitle)
      }
      else if (apConfig.title) {
        this.$titleField.val(apConfig.title)
      }
      else {
        this.$titleField.val('')
      }
    },
    addImage: function (e) {
      e.preventDefault();
      const $inputFile = $(e.target)
      this.file        = $inputFile.val()
      const filename   = this.getFileName(this.file)
      this.$inputFilename.val(filename)
      this.$image.attr('src', apConfig.image_uri + 'empty.png')
    },
    getFileName: function (file) {
      return file.split('\\').pop()
    },
    removeImage: function (e) {
      e.preventDefault()
      this.$inputFilename.val('')
      this.$image.attr('src', apConfig.image_uri + 'empty.png')
    },
    setCustomImage: function () {
      if (this.file) {
        this.$image.attr('src', apConfig.image_uri + 'empty.png')
        this.$inputFilename.val(this.getFileName(this.file))
      }
      else if (apConfig.icon) {
        this.$inputFilename.val(apConfig.icon)
        this.$image.attr('src', apConfig.icon)
      }
      else {
        this.$inputFilename.val('')
        this.$image.attr('src', apConfig.image_uri + 'empty.png')
      }
    }
  }

  document.addEventListener('DOMContentLoaded', function () {
    defaultConfiguration.init()
  })

} )(jQuery)
