<?php

namespace Giggsey\Locale\Tests;

use Giggsey\Locale\Locale;

class RegionTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @param string $locale Input locale
     * @param string $expectedRegion Expected output region
     * @dataProvider dataListOfRegions
     */
    public function testGetRegion($locale, $expectedRegion)
    {
        $this->assertEquals($expectedRegion, Locale::getRegion($locale));
    }

    /**
     * @see testGetRegion
     * @return array
     */
    public function dataListOfRegions()
    {
        return array(
            array('af-ZA', 'ZA'),
            array('am-ET', 'ET'),
            array('ar-AE', 'AE'),
            array('ar-BH', 'BH'),
            array('ar-DZ', 'DZ'),
            array('ar-EG', 'EG'),
            array('ar-IQ', 'IQ'),
            array('ar-JO', 'JO'),
            array('ar-KW', 'KW'),
            array('ar-LB', 'LB'),
            array('ar-LY', 'LY'),
            array('ar-MA', 'MA'),
            array('arn-CL', 'CL'),
            array('ar-OM', 'OM'),
            array('ar-QA', 'QA'),
            array('ar-SA', 'SA'),
            array('ar-SY', 'SY'),
            array('ar-TN', 'TN'),
            array('ar-YE', 'YE'),
            array('as-IN', 'IN'),
            array('az-Cyrl-AZ', 'AZ'),
            array('az-Latn-AZ', 'AZ'),
            array('ba-RU', 'RU'),
            array('be-BY', 'BY'),
            array('bg-BG', 'BG'),
            array('bn-BD', 'BD'),
            array('bn-IN', 'IN'),
            array('bo-CN', 'CN'),
            array('br-FR', 'FR'),
            array('bs-Cyrl-BA', 'BA'),
            array('bs-Latn-BA', 'BA'),
            array('ca-ES', 'ES'),
            array('co-FR', 'FR'),
            array('cs-CZ', 'CZ'),
            array('cy-GB', 'GB'),
            array('da-DK', 'DK'),
            array('de-AT', 'AT'),
            array('de-CH', 'CH'),
            array('de-DE', 'DE'),
            array('de-LI', 'LI'),
            array('de-LU', 'LU'),
            array('dsb-DE', 'DE'),
            array('dv-MV', 'MV'),
            array('el-GR', 'GR'),
            array('en-029', '029'),
            array('en-AU', 'AU'),
            array('en-BZ', 'BZ'),
            array('en-CA', 'CA'),
            array('en-GB', 'GB'),
            array('en-IE', 'IE'),
            array('en-IN', 'IN'),
            array('en-JM', 'JM'),
            array('en-MY', 'MY'),
            array('en-NZ', 'NZ'),
            array('en-PH', 'PH'),
            array('en-SG', 'SG'),
            array('en-TT', 'TT'),
            array('en-US', 'US'),
            array('en-ZA', 'ZA'),
            array('en-ZW', 'ZW'),
            array('es-AR', 'AR'),
            array('es-BO', 'BO'),
            array('es-CL', 'CL'),
            array('es-CO', 'CO'),
            array('es-CR', 'CR'),
            array('es-DO', 'DO'),
            array('es-EC', 'EC'),
            array('es-ES', 'ES'),
            array('es-GT', 'GT'),
            array('es-HN', 'HN'),
            array('es-MX', 'MX'),
            array('es-NI', 'NI'),
            array('es-PA', 'PA'),
            array('es-PE', 'PE'),
            array('es-PR', 'PR'),
            array('es-PY', 'PY'),
            array('es-SV', 'SV'),
            array('es-US', 'US'),
            array('es-UY', 'UY'),
            array('es-VE', 'VE'),
            array('et-EE', 'EE'),
            array('eu-ES', 'ES'),
            array('fa-IR', 'IR'),
            array('fi-FI', 'FI'),
            array('fil-PH', 'PH'),
            array('fo-FO', 'FO'),
            array('fr-BE', 'BE'),
            array('fr-CA', 'CA'),
            array('fr-CH', 'CH'),
            array('fr-FR', 'FR'),
            array('fr-LU', 'LU'),
            array('fr-MC', 'MC'),
            array('fy-NL', 'NL'),
            array('ga-IE', 'IE'),
            array('gd-GB', 'GB'),
            array('gl-ES', 'ES'),
            array('gsw-FR', 'FR'),
            array('gu-IN', 'IN'),
            array('ha-Latn-NG', 'NG'),
            array('he-IL', 'IL'),
            array('hi-IN', 'IN'),
            array('hr-BA', 'BA'),
            array('hr-HR', 'HR'),
            array('hsb-DE', 'DE'),
            array('hu-HU', 'HU'),
            array('hy-AM', 'AM'),
            array('id-ID', 'ID'),
            array('ig-NG', 'NG'),
            array('ii-CN', 'CN'),
            array('is-IS', 'IS'),
            array('it-CH', 'CH'),
            array('it-IT', 'IT'),
            array('iu-Cans-CA', 'CA'),
            array('iu-Latn-CA', 'CA'),
            array('ja-JP', 'JP'),
            array('ka-GE', 'GE'),
            array('kk-KZ', 'KZ'),
            array('kl-GL', 'GL'),
            array('km-KH', 'KH'),
            array('kn-IN', 'IN'),
            array('kok-IN', 'IN'),
            array('ko-KR', 'KR'),
            array('ky-KG', 'KG'),
            array('lb-LU', 'LU'),
            array('lo-LA', 'LA'),
            array('lt-LT', 'LT'),
            array('lv-LV', 'LV'),
            array('mi-NZ', 'NZ'),
            array('mk-MK', 'MK'),
            array('ml-IN', 'IN'),
            array('mn-MN', 'MN'),
            array('mn-Mong-CN', 'CN'),
            array('moh-CA', 'CA'),
            array('mr-IN', 'IN'),
            array('ms-BN', 'BN'),
            array('ms-MY', 'MY'),
            array('mt-MT', 'MT'),
            array('nb-NO', 'NO'),
            array('ne-NP', 'NP'),
            array('nl-BE', 'BE'),
            array('nl-NL', 'NL'),
            array('nn-NO', 'NO'),
            array('nso-ZA', 'ZA'),
            array('oc-FR', 'FR'),
            array('or-IN', 'IN'),
            array('pa-IN', 'IN'),
            array('pl-PL', 'PL'),
            array('prs-AF', 'AF'),
            array('ps-AF', 'AF'),
            array('pt-BR', 'BR'),
            array('pt-PT', 'PT'),
            array('qut-GT', 'GT'),
            array('quz-BO', 'BO'),
            array('quz-EC', 'EC'),
            array('quz-PE', 'PE'),
            array('rm-CH', 'CH'),
            array('ro-RO', 'RO'),
            array('ru-RU', 'RU'),
            array('rw-RW', 'RW'),
            array('sah-RU', 'RU'),
            array('sa-IN', 'IN'),
            array('se-FI', 'FI'),
            array('se-NO', 'NO'),
            array('se-SE', 'SE'),
            array('si-LK', 'LK'),
            array('sk-SK', 'SK'),
            array('sl-SI', 'SI'),
            array('sma-NO', 'NO'),
            array('sma-SE', 'SE'),
            array('smj-NO', 'NO'),
            array('smj-SE', 'SE'),
            array('smn-FI', 'FI'),
            array('sms-FI', 'FI'),
            array('sq-AL', 'AL'),
            array('sr-Cyrl-BA', 'BA'),
            array('sr-Cyrl-CS', 'CS'),
            array('sr-Cyrl-ME', 'ME'),
            array('sr-Cyrl-RS', 'RS'),
            array('sr-Latn-BA', 'BA'),
            array('sr-Latn-CS', 'CS'),
            array('sr-Latn-ME', 'ME'),
            array('sr-Latn-RS', 'RS'),
            array('sv-FI', 'FI'),
            array('sv-SE', 'SE'),
            array('sw-KE', 'KE'),
            array('syr-SY', 'SY'),
            array('ta-IN', 'IN'),
            array('te-IN', 'IN'),
            array('tg-Cyrl-TJ', 'TJ'),
            array('th-TH', 'TH'),
            array('tk-TM', 'TM'),
            array('tn-ZA', 'ZA'),
            array('tr-TR', 'TR'),
            array('tt-RU', 'RU'),
            array('tzm-Latn-DZ', 'DZ'),
            array('ug-CN', 'CN'),
            array('uk-UA', 'UA'),
            array('ur-PK', 'PK'),
            array('uz-Cyrl-UZ', 'UZ'),
            array('uz-Latn-UZ', 'UZ'),
            array('vi-VN', 'VN'),
            array('wo-SN', 'SN'),
            array('xh-ZA', 'ZA'),
            array('yo-NG', 'NG'),
            array('zh-CN', 'CN'),
            array('zh-HK', 'HK'),
            array('zh-MO', 'MO'),
            array('zh-SG', 'SG'),
            array('zh-TW', 'TW'),
            array('zu-ZA', 'ZA'),

            /*
             * Edge Cases
             */

            array('en', ''),
            array('ha-Latn', ''),
            array('en_US_POSIX', 'US'),

            array('en-gb', 'GB'),
            array('en_gb', 'GB'),
        );
    }
}
