<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\Tests\AddonPayments\SDK\_3DSecure\v2;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\SchemaObjectInterface;

/**
 * Implements some assertions and utility methods.
 */
trait TestsUtilityTrait
{
    protected function assertInvalidField(SchemaObjectInterface $instance, string $property, $currentValue): void
    {
        $instance->$property = $currentValue;
        $violations = $instance->validate();
        self::assertNotEmpty($violations, "Test field '${property}' with invalid value");
        self::assertArrayHasKey($property, $violations, "Test violations contains invalid field '${property}'");
        self::assertStringStartsWith(
            "The property '${property}' has an invalid value ${currentValue}, allowed values are",
            $violations[$property],
            "Test violation message for field '${property}'"
        );
    }

    protected function assertInvalidFieldLength(SchemaObjectInterface $instance, string $property, string $currentValue): void
    {
        $instance->$property = $currentValue;
        $violations = $instance->validate();
        self::assertNotEmpty($violations, "Test field '${property}' with invalid value");
        self::assertArrayHasKey($property, $violations, "Test violations contains invalid field '${property}'");
        self::assertStringStartsWith(
            "The property '${property}' length is greater than",
            $violations[$property],
            "Test violation message for field '${property}'"
        );
    }

    /**
     * @SuppressWarnings(PHPMD.BooleanArgumentFlag)
     */
    protected function generateString(int $length = 50, bool $includeSymbols = false): string
    {
        $alpha = range('a', 'z');

        if ($includeSymbols) {
            $symbols = ['.', ':', ',', ';', '?', '!', "\t", "\n", ' '];
            $alpha = array_merge($alpha, $symbols);
        }

        $output = '';
        $max = \count($alpha) - 1;

        while (\strlen($output) < $length) {
            $current = random_int(0, $max);
            $output .= $alpha[$current];
        }

        return $output;
    }
}
