<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\Tests\AddonPayments\SDK\_3DSecure\v2;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\ShippingAddress;
use PHPUnit\Framework\TestCase;

/**
 * Tests ShippingAddress model.
 */
class ShippingAddressTest extends TestCase
{
    use TestsUtilityTrait;

    /**
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\AbstractSchemaObject::__construct
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\AbstractSchemaObject::jsonSerialize
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\ShippingAddress
     */
    public function testGetDefaults(): void
    {
        $instance = new ShippingAddress();
        $expected = json_encode($instance->getDefaults());
        $actual = json_encode($instance);
        self::assertJsonStringEqualsJsonString($expected, $actual, 'Test object defaults and JSON serialization');
    }

//    /**
//     * @covers \EPG\_3DSecure\v2\Enum\BillAddressMatchEnum
//     * @covers \EPG\_3DSecure\v2\AbstractSchemaObject::__construct
//     * @covers \EPG\_3DSecure\v2\AbstractSchemaObject::getViolationMessage
//     * @covers \EPG\_3DSecure\v2\AbstractSchemaObject::validateLength
//     * @covers \EPG\_3DSecure\v2\AbstractSchemaObject::validateEnum
//     * @covers \EPG\_3DSecure\v2\ShippingAddress::validate
//     * @covers \EPG\_3DSecure\v2\ShippingAddress::getDefaults
//     */
//    public function testInvalid(): void
//    {
//        $instance = new ShippingAddress();
//        self::assertEmpty($instance->validate(), 'Test class defaults are valid');
//        $this->assertInvalidFieldLength($instance, 'address1', $this->generateString(60, true));
//        $this->assertInvalidFieldLength($instance, 'address2', $this->generateString(80, true));
//        $this->assertInvalidFieldLength($instance, 'city', $this->generateString(100, true));
//        $this->assertInvalidFieldLength($instance, 'zipCode', $this->generateString(20));
//        $this->assertInvalidFieldLength($instance, 'country', $this->generateString(6));
//        $this->assertInvalidFieldLength($instance, 'phone', $this->generateString(20));
//        $this->assertInvalidFieldLength($instance, 'deliveryEmail', $this->generateString(300));
//        $this->assertInvalidField($instance, 'billAddressMatchYN', '-');
//        $violations = $instance->validate();
//        self::assertNotEmpty($violations, 'Test class with custom invalid values');
//        self::assertCount(8, $violations, 'Test all class fields are invalid');
//    }

    /**
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\AbstractSchemaObject::__construct
     * @covers \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\ShippingAddress
     */
    public function testGetName(): void
    {
        self::assertEquals('shippingAddress', (new ShippingAddress())->getName());
    }
}
