<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\Tests\AddonPayments\SDK\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Psr7\Response;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\HandlerStack;

/**
 * Provides common methods for API tests.
 *
 * @SuppressWarnings(PHPMD.StaticAccess)
 */
trait TestUtilityTrait
{
    protected function assertConstructorInvalidConfiguration(string $class, array $configuration, string $parameter): void
    {
        $this->expectException(\InvalidArgumentException::class);
        $this->expectExceptionMessage(
            sprintf('Could not create API client instance, \'%s\' parameter is missing or invalid', $parameter)
        );
        $configuration[$parameter] = '';
        $httpClientMock = $this->getMockBuilder(Client::class)->disableOriginalConstructor()->getMock();
        new $class($configuration, $httpClientMock);
    }

    /**
     * Mock an API server and returns a HTTP client instance attached to it.
     */
    protected function mockServer(
        int $responseCode,
        array $responseBody = null
    ): ClientInterface {
        if (null !== $responseBody) {
            $responseBody = json_encode($responseBody);
        }
//        $mock = new Mock(
//            [new Response($responseCode, [], Stream::factory(json_encode($responseBody)))]
//        );

        $mock = new MockHandler([
            new Response($responseCode, [], json_encode($responseBody)),
        ]);

        $handlerStack = HandlerStack::create($mock);

        return new Client(['handler' => $handlerStack]);
    }

    /**
     * Returns the real path of the directory with fixtures keys.
     */
    protected function getKeysDirectory(): string
    {
        return \dirname(__DIR__, 2).'/fixtures/keys/';
    }
}
