<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Request;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\SchemaObjectInterface;

/**
 * Interface With3DSecureV2Interface.
 *
 * Defines an interface for request that need to include 3D Secure v2 schema.
 */
interface With3DSecureV2Interface extends RequestInterface
{
    /**
     * Adds a 3DSecure v2 schema object to the request payload.
     *
     * Allows parameter to be null to ease integration. Null arguments
     * will result on the set being ignored and the instance is returned
     * unchanged.
     */
    public function add3DSecureV2Object(SchemaObjectInterface $object = null): self;

    /**
     * Get 3DSecure v2 schema objects from request.
     *
     * @return \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\SchemaObjectInterface[]
     */
    public function get3DSecureV2(): array;
}
