<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Request;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Transactions.
 *
 * Maps data for 'transactions' request.
 *
 * @see https://api-developer.easypaymentgateway.com/EPGJS/#operation/Transaction%20Status
 *
 * @SuppressWarnings(PHPMD.ShortVariable)
 */
class TransactionsByDate extends AbstractEncryptedRequest
{
    public const API_FORMAT = 'Y/m/d H:i:s';

    /**
     * @var \DateTime
     * @Assert\NotNull()
     * @Assert\Type("\DateTime")
     */
    private $from;

    /**
     * @var \DateTime
     * @Assert\NotNull()
     * @Assert\Type("\DateTime")
     */
    private $to;

    public function setFrom(\DateTime $from): self
    {
        $this->from = $from;

        return $this;
    }

    public function setTo(\DateTime $to): self
    {
        $this->to = $to;

        return $this;
    }

    public function getFrom(): \DateTime
    {
        return $this->from;
    }

    public function getTo(): \DateTime
    {
        return $this->to;
    }

    public static function excludedProperties(): array
    {
        return array_merge(parent::excludedProperties(), ['from', 'to']);
    }

    public function jsonSerialize(): array
    {
        return array_merge(parent::jsonSerialize(), [
          'from' => !$this->from ?: $this->from->format(self::API_FORMAT),
          'to' => !$this->to ?: $this->to->format(self::API_FORMAT),
        ]);
    }
}
