<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Request;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class AbstractMITRequest.
 *
 * Abstraction for all merchant-initiated transactions (capture, void, refund).
 *
 * @SuppressWarnings(PHPMD.LongVariableNames)
 */
abstract class AbstractMITRequest extends AbstractEncryptedRequest
{
    /**
     * @var string
     * @Assert\NotNull()
     */
    protected $paymentSolution;

    /**
     * @var string
     * @Assert\NotNull()
     */
    protected $merchantTransactionId;

    /**
     * @var string
     * @Assert\NotNull()
     */
    protected $description;

    /**
     * @var array
     */
    protected $merchantParams = [];

    /**
     * @var string
     * @Assert\NotNull()
     */
    protected $transactionId;

    public function getMerchantParams(): array
    {
        return $this->merchantParams;
    }

    public function addMerchantParam(string $key, string $value): self
    {
        $this->merchantParams[$key] = $value;

        return $this;
    }

    public function setMerchantParams(array $merchantParams): self
    {
        $this->merchantParams = $merchantParams;

        return $this;
    }

    public function getPaymentSolution(): string
    {
        return $this->paymentSolution;
    }

    public function setPaymentSolution(string $paymentSolution): self
    {
        $this->paymentSolution = $paymentSolution;

        return $this;
    }

    public function getMerchantTransactionId(): string
    {
        return $this->merchantTransactionId;
    }

    public function setMerchantTransactionId(string $merchantTransactionId): self
    {
        $this->merchantTransactionId = $merchantTransactionId;

        return $this;
    }

    public function setDescription(string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function setTransactionId(string $transactionId): self
    {
        $this->transactionId = $transactionId;

        return $this;
    }

    public function getTransactionId(): string
    {
        return $this->transactionId;
    }
}
