<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Request;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\SchemaObjectInterface;

/**
 * Class Abstract3DSecureV2Request.
 *
 * Base class for request with 3DSecureV2 schema.
 *
 * @SuppressWarnings(PHPMD.CamelCasePropertyName)
 */
abstract class Abstract3DSecureV2Request extends AbstractRequest implements With3DSecureV2Interface
{
    /**
     * @var \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\SchemaObjectInterface[]
     */
    private $_3DSecureV2 = [];

    public function add3DSecureV2Object(SchemaObjectInterface $object = null
    ): With3DSecureV2Interface {
        if (null === $object) {
            return $this;
        }

        $this->_3DSecureV2[$object->getName()] = $object;

        return $this;
    }

    /**
     * @return \ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\SchemaObjectInterface[]
     */
    public function get3DSecureV2(): array
    {
        return $this->_3DSecureV2;
    }

    public static function excludedProperties(): array
    {
        return array_merge(parent::excludedProperties(), [
            '_3DSecureV2',
        ]);
    }

    public function jsonSerialize(): array
    {
        $data = parent::jsonSerialize();
        foreach ($this->_3DSecureV2 as $key => $object) {
            $data[$key] = $object->jsonSerialize();
        }

        return $data;
    }
}
