# Addon Payments PHP SDK

@TODO Add some docs here.

## Encryption

### Using ECB and CBC

The package provides AES-256-ECB and AES-256-CBC cypher through 2 utility
classes with similar names. These are used by the API client during request
build time but can used in any other scenario where data may be required to be
encrypted using any of these methods.

Both classes have same methods with the slight difference that CBC requires
a initialization vector (IV), which can be generated by the class itself as
shown below.

```php
$plainText = 'The quick brown fox jumps over the lazy dog';
$key = 'threepwood';
// Using CBC.
use ComerciaGlobalPayments\AddonPayments\SDK\Encryption\Cypher\Aes256Cbc;use ComerciaGlobalPayments\AddonPayments\SDK\Encryption\Cypher\Aes256Ecb;
$cbc = new Aes256Cbc();
// Can throw an exception if cannot generate a secure IV,
// check the method for more information about it.
$iv = $cbc->generateIv();
$encryptedText = $cbc->encrypt($plainText, $key, $iv);
$decryptedText = $cbc->decrypt($encryptedText, $key, $iv);
assert(strcasecmp($decryptedText, $plainText), 'Text matches');
// --------------------------------
// Using ECB.
$ebc = new Aes256Ecb();
$encryptedText = $ebc->encrypt($plainText, $key);
$decryptedText = $ebc->decrypt($encryptedText, $key);
assert(strcasecmp($decryptedText, $plainText), 'Text matches');
```

#### Acknowledgment

The implementation of these methods was taken from [php-simple-encryption][gh-pse] package
but due project's PHP minimum version requirement set to 7.1 the package cannot
be use. Thanks to [John Conde][gh-stymiee] for his wonderful open-source project.

[gh-pse]: https://github.com/stymiee/php-simple-encryption
[gh-stymiee]: https://github.com/stymiee
[jwt-rfc]: https://tools.ietf.org/html/rfc7519
