<?php
$orders = array();
$url    = admin_url( 'admin-ajax.php' );
?>
<div class="wrap">
	<table class="wp-list-table widefat fixed striped table-view-list posts">
		<thead>
		<tr>
			<th><?php echo __( 'Transaction Id', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Order', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Quantity', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Currency', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Operation type', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Payment Solution', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Status', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Created', 'addonpayments' ); ?></th>
			<th><?php echo __( 'Updated', 'addonpayments' ); ?></th>
		</tr>
		</thead>
		<tbody>
		<?php
		foreach ( $transactions as $transaction ) :
			if ( ! isset( $orders[ $transaction->id_order ] ) ) {
				$orders[ $transaction->id_order ] = wc_get_order( $transaction->id_order );
			}
			$order = $orders[ $transaction->id_order ];
			?>
			<tr>
				<td><?php echo $transaction->payFrexTransactionId; ?></td>
				<td><?php echo $order->get_id(); ?></td>
				<td><?php echo $transaction->amount; ?></td>
				<td><?php echo $transaction->currency; ?></td>
				<td><?php echo $transaction->operationType; ?></td>
				<td><?php echo $transaction->paymentSolution; ?></td>
				<td>
					<?php if ( $order->get_status() == 'on-hold' ) : ?>
						<a href="#" class="epg-capture-order" data-order="<?php echo $transaction->id_order; ?>"
						   data-transaction="<?php echo $transaction->payFrexTransactionId; ?>"
						   data-url="<?php echo $url; ?>"><?php echo __( 'Capture', 'addonpayments' ); ?></a>
					<?php else : ?>
						<?php echo $transaction->status; ?>
					<?php endif; ?>
				</td>
				<td><?php echo $transaction->createdAt; ?></td>
				<td><?php echo $transaction->updatedAt; ?></td>
			</tr>
		<?php endforeach; ?>
		</tbody>
	</table>
	<?php if ( isset( $totalPages ) && $totalPages > 1 ) : ?>
		<div id="epg-transactions-paginator">
			<?php if ( $page > 0 ) : ?>
				<a href="?page=wpg-transactions&transaction_page=<?php echo ( $page - 1 ); ?>" class="previous"></a>
			<?php endif; ?>
			<?php for ( $i = 0; $i < $totalPages; ++ $i ) : ?>
				<a href="?page=wpg-transactions&transaction_page=<?php echo $i; ?>" class="page-link"><?php echo ( $i + 1 ); ?></a>
			<?php endfor; ?>
			<?php if ( $page + 1 < $totalPages ) : ?>
				<a href="?page=wpg-transactions&transaction_page=<?php echo ( $page + 1 ); ?>" class="next"></a>
			<?php endif; ?>
		</div>
	<?php endif; ?>

</div>
