<tr valign="top" class="<?php echo esc_attr( $data['tr_class'] ); ?>">
	<th scope="row" class="titledesc">
		<label for="<?php echo esc_attr( $field_key ); ?>"><?php echo wp_kses_post( $data['title'] ); ?><?php echo $this->get_tooltip_html( $data ); // WPCS: XSS ok. ?></label>
	</th>

	<td class="forminp">
		<fieldset id="addonpayments-icon-fieldset">
			<legend class="screen-reader-text">
				<span><?php echo wp_kses_post( $data['title'] ); ?></span>
			</legend>

			<?php if ( ! empty ( $value ) ): ?>
            <div class="addonpayments-icon-image-wrapper">
                <img  id="addonpayments-icon-image" alt="<?php echo wp_kses_post( $data['title'] ); ?>" src="<?php echo esc_url( $value ) ?>" style="max-height: 50px"/>
            </div>
			<?php endif; ?>

            <div class="addonpayments-icon-file-wrapper <?php echo ( $data['readonly'] ) ? 'hidden' : ''; ?>">
	            <div>
	                <input type="text" id="addonpayments-icon-filename" name="addonpayments-icon-filename" readonly value="<?php echo esc_url( $value ) ?>" />
	                <input id="addonpayments-icon-file" class="input-file regular-input <?php echo esc_attr( $data['class'] ); ?>" type="file" name="<?php echo esc_attr( $field_key ); ?>" id="<?php echo esc_attr( $field_key ); ?>" style="<?php echo esc_attr( $data['css'] ); ?>" <?php echo $this->get_custom_attribute_html( $data ); // WPCS: XSS ok. ?> />
	            </div>
	            <button id="addonpayments-icon-add" class="button button-primary"><?php _e( 'Select file', 'addonpayments' ) ?></button>
                <button id="addonpayments-icon-remove" class="button button-secondary"><span class="dashicons dashicons-trash"></span><?php _e( 'Delete', 'addonpayments' ) ?></button>
            </div>

            <?php echo $this->get_description_html( $data ); // WPCS: XSS ok. ?>

		</fieldset>
	</td>

</tr>