<?php

namespace WooCommerce\Plugin\AddonPayments;

class ConfirmationController {

	public function __construct() {
		add_action( 'init', array( $this, 'rewrite_rules' ) );
		add_filter( 'query_vars', array( $this, 'query_vars' ) );
		add_action( 'template_include', array( $this, 'include_template' ) );
	}

	public function rewrite_rules() {
		add_rewrite_rule( 'epg_confirmation/(.+?)/?$', 'index.php?epg_confirmation=$matches[1]', 'top' );
	}

	public function query_vars( $query_vars ) {
		$query_vars[] = 'epg_confirmation';

		return $query_vars;
	}

	public function include_template( $template ) {
		$epg_confirmation = get_query_var( 'epg_confirmation' );
		if ( $epg_confirmation ) {
			return EPG_BASE_DIR . '/assets/php/confirmation.php';
		}

		return $template;
	}
}
