<?php
/**
 * Settings for Easy Payment Gateway.
 *
 * @package Addonpayment
 */

defined( 'ABSPATH' ) || exit;

$config_hidden = empty( $this->settings[ AP_Config::DEFAULT_CONFIGURATION] ) ? 'hidden ' : '';
$default_config_options = AP_Config::getDefaultPaymentConfig();
$readonly = !empty( $this->settings[ AP_Config::DEFAULT_CONFIGURATION] )
            && AP_Config::DEFAULT_OPTION_CUSTOM !== $this->settings[ AP_Config::DEFAULT_CONFIGURATION]
			? ['readonly' => 'readonly'] : [];

return [
	'enabled'        => [
		'type'    => 'checkbox',
		'title'   => __( 'Enable/Disable', 'addonpayments' ),
		'label'   => __( 'Enable Addon Payments as a Payment option', 'addonpayments' ),
		'default' => 'no',
	],
	'live_mode'      => [
		'type'    => 'checkbox',
		'title'   => __( 'Live Mode', 'addonpayments' ),
		'label'   => __( 'Use this module in live mode', 'addonpayments' ),
		'default' => 'no',
	],
	AP_Config::DEFAULT_CONFIGURATION => [
		'type'        => 'select',
		'title'       => __( 'Default Configuration', 'addonpayments' ),
		'options'     => [
			''                                          => __( 'Select the default configuration', 'addonpayments' ),
			AP_Config::DEFAULT_OPTION_CREDIT_CARD       => __( 'Credit Card', 'addonpayments' ),
			AP_Config::DEFAULT_OPTION_CREDIT_CARD_BIZUM => __( 'Credit Card or Bizum', 'addonpayments' ),
			AP_Config::DEFAULT_OPTION_QUIX              => __( 'Quix financing', 'addonpayments' ),
			AP_Config::DEFAULT_OPTION_MULTIPLE          => __( 'Multiple payment methods', 'addonpayments' ),
			AP_Config::DEFAULT_OPTION_GLOBALPAYMENTS    => __( 'Powered by Globalpayments', 'addonpayments' ),
			AP_Config::DEFAULT_OPTION_CUSTOM            => __( 'Custom', 'addonpayments' ),
		],
		'description' => __( 'Modify the title and logo configuration of the gateway or customise it if you prefer.', 'addonpayments' ),
	],
	'title' => [
		'type'              => 'text',
		'title'             => __( 'Title', 'woocommerce' ),
		'description'       => __( 'This controls the title which the user sees during checkout.', 'addonpayments' ),
		'default'           => 'Addon Payments',
		'tr_class'          => $config_hidden . 'default-config',
		'custom_attributes' => $readonly,
	],
	'icon' => [
		'type'        => 'addonpayments_icon',
		'title'       => __( 'Logo', 'addonpayments' ),
		'description' => __( 'This controls the payment logo which the user sees during checkout.', 'addonpayments') . sprintf(__('%s Allowed formats are: .gif, .jpg, .png.%s', 'addonpayments' ), '<span class="hidden">', '</span>'),
		'tr_class'    => $config_hidden . 'default-config',
		'readonly'    => ! empty( $readonly ),
	],
	'merchant_id'    => [
		'type'        => 'text',
		'title'       => __( 'Merchant ID', 'addonpayments' ),
		'description' => __( 'This value will be encrypted once stored in your database.', 'addonpayments' ),
		'default'     => '',
	],
	'api_key'        => [
		'type'        => 'text',
		'title'       => __( 'API Key', 'addonpayments' ),
		'description' => __( 'This value will be encrypted once stored in your database.', 'addonpayments' ),
		'default'     => '',
	],
	'password'       => [
		'type'        => 'text',
		'title'       => __( 'Password', 'addonpayments' ),
		'description' => __( 'This value will be encrypted once stored in your database.', 'addonpayments' ),
		'default'     => '',
	],
	'product_id'     => [
		'type'        => 'text',
		'title'       => __( 'Product ID', 'addonpayments' ),
		'description' => __( 'This is the product ID provided to you by EPG', 'addonpayments' ),
		'default'     => '',
	],
	'settle'         => [
		'type'    => 'checkbox',
		'title'   => __( 'Automatic capture', 'addonpayments' ),
		'label'   => __( 'If checked, all purchases will be authorized and captured automatically on payment step during checkout. ' .
		                 'If unchecked, purchases will be only authorized to be captured later. To know more about ' .
		                 'capturing purchases check the documentation.', 'addonpayments' ),
		'default' => 'yes',
	],
	'financing_section' => [
		'type'        => 'title',
		'title' =>  __( 'Financing', 'addonpayments' ),
		'description' => __( 'Only applies if the CaixaBank Payments & Consumer (CPC) "Quix" financing payment ' .
		                     'service has been activated and contracted. Service that connects buyers and financing ' .
		                     'services. Allows you to configure payment in instalments (up to 12 months).', 'addonpayments' ),
	],
	'banner_position' => [
		'type'        => 'select',
		'title'       => __( 'Financing banner position', 'addonpayments' ),
		'options'     => [
			1 => __( 'Below the product price', 'addonpayments' ),
			2 => __( 'Below the add to cart button', 'addonpayments' ),
		],
		'description' => __( "This controls the banner position on product page", 'addonpayments' ),
		'default'     => 1,
	],
	'banner_style_color'    => [
		'type'        => 'color',
		'title'       => __( 'Financing banner color', 'addonpayments' ),
		'description' => __( "This color will be used to customize some elements of the banner.", 'addonpayments' ),
		'default'     => '#34AEEB',
	],
	'banner_style_variant'  => [
		'type'        => 'select',
		'title'       => __( 'Financing banner variant', 'addonpayments' ),
		'options'     => [
			'text_banner'   => __( 'Text Banner', 'addonpayments' ),
			'text'          => __( 'Text', 'addonpayments' ),
			'select'        => __( 'Select', 'addonpayments' ),
			'select_banner' => __( 'Select Banner', 'addonpayments' ),
		],
		'description' => __( "", 'addonpayments' ),
		'default'     => "text_banner",
	],
	'banner_style_branding' => [
		'type'        => 'select',
		'title'       => __( 'Financing style branding', 'addonpayments' ),
		'options'     => [
			'lending_hub' => __( 'Lending hub', 'addonpayments' ),
		],
		'description' => __( "", 'addonpayments' ),
		'default'     => 'lending_hub',
	],

	'success_url'    => [
		'type'        => 'text',
		'title'       => __( 'Success URL (optional)', 'addonpayments' ),
		'description' => __( 'The URL to where the user will be redirected to on successful payments', 'addonpayments' ),
		'default'     => '',
	],
	'failure_url'    => [
		'type'        => 'text',
		'title'       => __( 'Failure URL (optional)', 'addonpayments' ),
		'description' => __( 'The URL to where the user will be redirected to when user cancel the payment', 'addonpayments' ),
		'default'     => '',
	],
	'cancel_url'     => [
		'type'        => 'text',
		'title'       => __( 'Cancel URL (optional)', 'addonpayments' ),
		'description' => __( 'The URL to where the user will be redirected to on failed payments', 'addonpayments' ),
		'default'     => '',
	],
];