<?php

global $wpdb;

$sql      = array();
$dbPrefix = $wpdb->prefix;
$charset  = DB_CHARSET;

$sql[] = "CREATE TABLE `{$dbPrefix}epg_transaction` (
    `id_epg_transaction`           INT UNSIGNED    NOT NULL    AUTO_INCREMENT,
    `id_order`                     INT UNSIGNED                                 NULL,
    `payFrexTransactionId`         VARCHAR(255)                                 NOT NULL,
    `merchantTransactionId`        VARCHAR(255)                                 NOT NULL,
    `sortedOrder`                  INT            DEFAULT 1                     NOT NULL,
    `EPGTransactionID`             VARCHAR(255)                                 NOT NULL,
    `amount`                       DECIMAL(20, 6) DEFAULT 0.000000              NULL,
    `currency`                     VARCHAR(16)                                  NOT NULL,
    `originalPayfrexTransactionId` VARCHAR(255)                                 NULL,
    `originalAmount`               DECIMAL(20, 6) DEFAULT 0.000000              NULL,
    `originalCurrency`             VARCHAR(16)                                  NULL,
    `remainingAmount`              DECIMAL(20, 6) DEFAULT 0.000000              NULL,
    `fee`                          DECIMAL(20, 6) DEFAULT 0.000000              NULL,
    `details`                      BLOB                                         NULL,
    `message`                      VARCHAR(255)                                 NULL,
    `operationType`                VARCHAR(64)                                  NULL,
    `paymentDetails`               BLOB                                         NULL,
    `optionalTransactionParams`    BLOB                                         NULL,
    `paymentSolution`              VARCHAR(64)                                  NOT NULL,
    `paySolTransactionId`          VARCHAR(255)                                 NULL,
    `respCode`                     BLOB                                         NULL,
    `status`                       VARCHAR(255)                                 NOT NULL,
    `lastOp`                       BOOL           DEFAULT FALSE                 NULL,
    `rawData`                      LONGBLOB                                     NULL,
    `createdAt`                    TIMESTAMP      DEFAULT '0000-00-00 00:00:00' NOT NULL,
    `updatedAt`                    TIMESTAMP      DEFAULT current_timestamp()   NOT NULL,
     PRIMARY KEY  (`id_epg_transaction`),
     UNIQUE KEY transaction_record (`payFrexTransactionId`, `merchantTransactionId`, `sortedOrder`)
) DEFAULT CHARSET={$charset};
";

$sql[] = "CREATE TABLE `{$dbPrefix}epg_card_token` (
    `id_token`      INT(8) UNSIGNED     NOT NULL    AUTO_INCREMENT,
    `customer_id`   INT(10) UNSIGNED    NOT NULL,
    `accountId`     VARCHAR(256)        NOT NULL,
    `paymentMethod` VARCHAR(100)        NOT NULL,
    `name`          VARCHAR(256)        NOT NULL,
    `cardType`      VARCHAR(256)        NOT NULL,
    `cardNumber`    VARCHAR(64)         NOT NULL,
    `cardToken`     VARCHAR(64)         NOT NULL,
    `rawData`       LONGBLOB            NULL,
    `createdAt`     TIMESTAMP           NOT NULL,
    `lastUsed`      TIMESTAMP           NOT NULL,
    PRIMARY KEY  (`id_token`),
    UNIQUE KEY unique_token (`cardToken`)
) DEFAULT CHARSET={$charset};";

$sql[] = "CREATE TABLE `{$dbPrefix}epg_card_attempts` (
    `id_attempt`    INT(10) UNSIGNED    NOT NULL    AUTO_INCREMENT,
    `customer_id`   INT(10) UNSIGNED    NOT NULL,
    `rawData`       LONGBLOB            NULL,
    `date`          TIMESTAMP           NOT NULL,
    PRIMARY KEY  (`id_attempt`)
) DEFAULT CHARSET={$charset};";

require_once ABSPATH . 'wp-admin/includes/upgrade.php';
dbDelta( $sql );

$sql[] = $wpdb->query(
	"CREATE INDEX IF NOT EXISTS parent_transaction
    ON {$dbPrefix}epg_transaction (`originalPayfrexTransactionId`);"
	);

// For the CardVault Endpoint
add_rewrite_endpoint( 'card-vault', EP_PAGES );
flush_rewrite_rules(); // It avoids having to go to Settings > Permalinks > Save Permalink