jQuery(
	function ($) {
		$( '.epg-capture-order' ).on(
			'click',
			capture
		);

		function capture( e ) {
			e.preventDefault();

			var target = $( e.target )
			target.prop( "disabled", true )
			$( 'body' ).css( 'cursor', 'progress' );
			$( 'body.post-type-shop_order .wp-list-table .no-link' ).attr( 'style', 'cursor: progress !important' );

			$.ajax(
				{
					method: 'POST',
					url: target.attr('data-url'),
					data: {
						action: 'epg-capture',
						transaction: target.attr('data-transaction')
					},
					success: function (result) {
						result = JSON.parse(result)
						if ( 'success' === result['status'] ) {
							location.reload()
						}
						else {
							console.error(result)
							$( 'body' ).css( 'cursor', '' );
							$( 'body.post-type-shop_order .wp-list-table .no-link' ).css( 'cursor', '' );
							target.prop( "disabled", false )
							alert('Ha habido un error con la captura: ' + result['msg'])
						}
					}
				}
			)
		}
	}
);
