jQuery(
	function ($) {
		$( 'body' ).on(
			'checkout_error',
			function (e) {
				console.error( e );
			}
		);
		$( 'body' ).on(
			'message',
			function (e) {
				console.log( e );
			}
		);

		$( '.delete-card-vault' ).on(
			'click',
			function (evt) {
				evt.preventDefault();
				$.ajax(
					{
						method: "POST",
						url: cardVault.attr( 'data-url' ),
						data: {
							action: 'card-vault-delete',
							accountId: $( evt.currentTarget ).attr( 'data-reference' )
						},
						success: function (result) {
							result = JSON.parse( result );
							if (result['status'] == 'success') {
								location.reload();
							} else {
								console.error( result );
							}
						}
					}
				);
			}
		);

		function registerAccountErrorCallback(data) {
			try {
				switch (true) {
					case (data.message.indexOf( 'expired' ) !== -1):
						var expired = $( '#addonpayments-expired' );
						expired.removeClass( 'hidden' );
						break;
					case (data.message.indexOf( 'Reached limit accounts for the paysol' ) !== -1):
						var error = $( '#addonpayments-error' );
						error.html( cardVault_object.texts.reachedPaysolLimit );
						error.removeClass( 'hidden' );
						break;
					default:
						var error = $( '#addonpayments-error' );
						error.html( cardVault_object.texts.unknownError );
						error.removeClass( 'hidden' );
						console.debug( data );
				}
			} catch (e) {
				console.error( e );
			}
		}

		function registerAccountCallback(payload) {

			if (null === cardVault || 'undefined' === (typeof cardVault)) {
				return;
			}

			payload.customer = cardVault.attr( 'data-customer' );
			$.ajax(
				{
					method: "POST",
					url: cardVault.attr( 'data-url' ),
					data: {
						action: 'card-vault',
						registerResponse: payload
					},
					success: function (result) {
						result = JSON.parse( result );
						if (result['status'] == 'success') {
							location.reload();
						} else {
							console.error( result );
							var error = $( '#addonpayments-error' );
							error.html( result['msg'] );
							error.removeClass( 'hidden' );
							console.debug( data );
						}
					}
				}
			);
		}

		var cardVault = $( '#card-vault-easypaymentgateway' );

		if (null === cardVault || 'undefined' === (typeof cardVault)) {
			return;
		}
		var instanceId = cardVault.attr( 'data-instance' );
		var token      = cardVault.attr( 'data-token' );

		try {
			EPGJS_COMM.setEpgBaseUrl( 'https://epgjs-web-stg.easypaymentgateway.com/' );
			EPGJS_COMM.setShowOnlyCardRegister( true );
			EPGJS_COMM.setOnlyRegisteredAccounts( true );
			EPGJS_STYLE.setCssTheme( EPGJS_STYLE['DEFAULT_BOOTSTRAP_THEME'] );
			EPGJS_COMM.setMerchantRegisterAccountCallback( registerAccountCallback );
			EPGJS_COMM.setRegisterAccountErrorCallback( registerAccountErrorCallback );
			EPGJS_I18N.setLang( cardVault_object.locale );
			EPGJS_I18N.setI18n( cardVault_object.i18n );
			EPGJS.renderCashier( token, 'wp-easypaymentgateway-vault-' + instanceId );
		} catch (error) {
			console.error( error );
			alert( 'error' );
		}
	}
);
