<?php
/**
 * Plugin Name: Addon Payments
 * Description: Integrates Addon Payments as a plugin for Woocommerce
 * Author: Comercia Global Payments
 * Version: 1.2.0
 * Author URI: https://easypaymentgateway.com/
 * Requires PHP: 7.0
 * Domain Path: /languages
 *
 * @package Addonpayments
 * @version 1.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

require_once __DIR__ . '/vendor/autoload.php';

define( 'ID_EPG', 'addonpayments' );

define( 'ADDONPAYMENTS_VERSION', '1.2.0' );

define( 'ADDONPAYMENTS_PLUGIN_FILE', __FILE__ );

/**
 * Addonpayments install
 */
function addonpayments_install() {
	if ( ! in_array(
		'woocommerce/woocommerce.php',
		apply_filters( 'active_plugins', get_option( 'active_plugins' ) ),
		true
	) ) {
		die( esc_html__( 'Plugin needs woocommerce plugin enabled to work', 'addonpayments' ) );
	}

	include_once 'includes/install.php';
}

/**
 * Addonpayments uninstall
 */
function addonpayments_uninstall() {
	delete_option( 'woocommerce_addonpayments_settings' );
}

register_activation_hook( __FILE__, 'addonpayments_install' );
register_deactivation_hook( __FILE__, 'addonpayments_uninstall' );

if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
	define( 'EPG_BASE_DIR', __DIR__ );
	define( 'EPG_PLUGIN_NAME', plugin_basename( __FILE__ ) );

	add_action(
		'plugins_loaded',
		function () {
			load_plugin_textdomain( ID_EPG, false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
			include 'includes/class-wc-gateway-easypaymentgateway.php';
			add_filter(
				'woocommerce_payment_gateways',
				function ( $methods ) {
					$methods[] = 'WC_Gateway_EasyPaymentGateway';

					return $methods;
				}
			);
		}
	);

	add_action( 'init', function () {
		register_post_status( 'wc-partial-refund', array(
			'label'                     => __( 'Partial refund', 'addonpayments' ),
			'public'                    => true,
			'exclude_from_search'       => false,
			'show_in_admin_all_list'    => true,
			'show_in_admin_status_list' => true,
			'label_count'               => _n_noop(
				sprintf(__('Partial refund %s', 'addonpayments'), '<span class="count">(%s)</span>'),
				sprintf(__('Partial refunds %s', 'addonpayments'), '<span class="count">(%s)</span>')
			)
		) );
	} );

	new \WooCommerce\Plugin\AddonPayments\CardVault();
	new \WooCommerce\Plugin\AddonPayments\TransactionsController();
	new \WooCommerce\Plugin\AddonPayments\InfoPage();

	include 'includes/class-ap-config.php';
	include 'includes/class-ap-quix-helper.php';
	include 'includes/class-ap-callback-controller.php';
	include 'includes/class-ap-status-controller.php';
	include 'includes/class-ap-banner.php';
	include 'includes/class-ap-quix-refund.php';

	new AP_Banner();
	new AP_Quix_Refund();
}


