/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2021 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 *
 * Don't forget to prefix your containers with your own identifier
 * to avoid any conflicts with others containers.
 */
document.addEventListener('DOMContentLoaded', function () {

    if (addonpayments.paymentSolution !== 'nemuru' && addonpayments.paymentSolution !== 'quix') {

        $(document).on('click', '#desc-order-partial_refund', function () {
            if ($('#partialRefundAddonpayments').length == 0) {
                let newCheckBox = `<p class="checkbox"><label for="partialRefundAddonpayments">
                <input type="checkbox" id="partialRefundAddonpayments" name="partialRefundAddonpayments" value="1">
                 ${addonpayments.partialRefundLiteral}</label></p>`;
                $('button[name=partialRefund]').parent('.partial_refund_fields').prepend(newCheckBox);
            }
        });

        // PS 1.7.7
        $(document).on('click', '.partial-refund-display', function () {
            if ($('#partialRefundAddonpayments').length == 0) {
                let newCheckBox = `
                    <div class="cancel-product-element form-group" style="display: block;">
                            <div class="checkbox">
                                <div class="md-checkbox md-checkbox-inline">
                                  <label>
                                      <input type="checkbox" id="partialRefundAddonpayments" name="partialRefundAddonpayments" material_design="material_design" value="1">
                                      <i class="md-checkbox-control"></i>
                                         ${addonpayments.partialRefundLiteral}
                                    </label>
                                </div>
                            </div>
                     </div>`;

                $('.refund-checkboxes-container').prepend(newCheckBox);
            }
        });

    }

    var $alert = $('.addonpayments-alert');

    if ($alert.length > 0) {
        $alert.insertBefore($('.kpi-container'));
    }
});


(function ($) {

    const refundByQuix = {
        init: function () {
            this.config();
        },
        config: function () {
            this.$quixRefundButton = $('body').find('#desc-order-quix_refund');
            if (!this.$quixRefundButton) return;

            this.$quixRefundButton.on('click', this.refund.bind(this));
        },
        refund: function (e) {
            e.preventDefault();
            const that = this;

            $.ajax({
                url: addonpayments.ajaxHandler,
                type: 'POST',
                dataType: 'JSON',
                data: {
                    ajax: true,
                    action: 'QuixRefundAction',
                    employee: addonpayments.employee,
                    customer: addonpayments.customer,
                    id_order: addonpayments.id_order
                },

                success: function (response) {
                    if(response.hasOwnProperty('error')) {
                         console.error(response.error);
                         return;
                    }

                    NEMURUORDERMANAGEMENT.setEpgBaseUrl(addonpayments.base_url);
                    NEMURUORDERMANAGEMENT.renderOrderManagementWidget(response, 'epgjs-cashier-div',
                      that.closeCallback,
                      that.errorCallback,
                      that.successCallback
                    );
                },
            });
        },
        successCallback: function (action) {
        },
        errorCallback: function (action) {
        },
        closeCallback: function (action) {
            const callback = atob(addonpayments.callback)
            window.location.replace(callback);
        }
    }

    const removeDocuments = {
        init: function() {
            this.config();
            this.remove();
            this.setBadge();
        },
        config: function() {
            this.$tabCount = $('#orderDocumentsTab .count');
            this.$tabContent = $('#orderDocumentsTabContent');
        },
        setBadge: function() {
            this.$tabCount.text(this.$tabContent.find('tr .documents-table-column-download-link').length);
        },
        remove: function() {
            this.$tabContent.find('tr').each(function() {
                let href = $(this).find('.documents-table-column-download-link a').attr('href');
                let amount = $(this).find('.documents-table-column-amount p').text();

                if(amount.length === 0) return;

                if(href.includes('generateOrderSlipPDF') && amount.includes('0' +addonpayments.currency_specifications.symbol[0]+'00')) {
                    $(this).remove();
                }
            })
        }
    }

    document.addEventListener('DOMContentLoaded', function () {
        if(addonpayments.is_177) {
            removeDocuments.init();
        }

        if ('quix' === addonpayments.paymentSolution || 'nemuru' === addonpayments.paymentSolution) {
            refundByQuix.init();
        } else {
            // refundByAddonpayments.init();
        }

    })

})(jQuery)
