<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\Tests\AddonPayments\SDK\Api\Unit;

use ComerciaGlobalPayments\AddonPayments\SDK\Request\AbstractRequest;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class SampleRequest.
 *
 * Sample of a request model.
 *
 * @codeCoverageIgnore
 */
class SampleRequest extends AbstractRequest
{
    /**
     * @var string[]
     * @Assert\NotNull()
     * @Assert\Choice(
     *     callback="getChoices",
     *     min=1,
     *     max=2,
     *     multiple=true,
     *     strict=true,
     *     minMessage="You must specify at least one choice",
     *     maxMessage="You cannot specify more than {{ limit }} choices",
     *     message="The value you selected is not a valid choice",
     *     multipleMessage="One or more of the given values is not a valid choices"
     * )
     */
    private $foo;

    /**
     * @return string[]
     */
    public function getFoo(): array
    {
        return $this->foo;
    }

    /**
     * @param string[] $foo
     */
    public function setFoo(array $foo): void
    {
        $this->foo = $foo;
    }

    /**
     * @return string[]
     */
    public function getChoices(): array
    {
        return ['bar', 'baz'];
    }
}
