<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2;

use ComerciaGlobalPayments\AddonPayments\SDK\_3DSecure\v2\Enum as _Enum;

/**
 * Class RiskValidation.
 *
 * Models risk validation data for the 3DSecureV2 schema.
 */
class RiskValidation extends AbstractSchemaObject
{
    /**
     * Property constants.
     */
    public const CHALLENGE = 'challenge';

    public const DELIVERY_TIME_FRAME = 'deliveryTimeFrame';

    public const PRE_ORDER_DATE = 'preOrderDate';

    public const PRE_ORDER_PURCHASE = 'preOrderPurchase';

    public const REODER_ITEMS = 'reorderItems';

    public const SHIPPING_METHOD = 'shippingMethod';

    public const TRANSACTION_TYPE_ID = 'transactionTypeId';

    /**
     * @var string Merchant can request the 3ds challenge
     */
    private $challenge;

    /**
     * @var string Indicates the merchandise delivery timeframe
     */
    private $deliveryTimeFrame;

    /**
     * @var string|null For a pre-ordered purchase, the expected date that the merchandise will be available formatted
     *                  as Y-m-d
     */
    private $preOrderDate;

    /**
     * @var string Indicates whether the order is for merchandise with a future availability or release date
     */
    private $preOrderPurchase;

    /**
     * @var string Indicates whether the cardholder is reordering previously purchased merchandise
     */
    private $reorderItems;

    /**
     * @var string Indicates shipping method chosen for the transaction
     */
    private $shippingMethod;

    /**
     * @var string Identifies the type of transaction being authenticated
     */
    private $transactionTypeId;

    public function setChallenge(string $challenge): self
    {
        $this->challenge = (string) (new _Enum\ChallengeEnum($challenge));

        return $this;
    }

    public function setDeliveryTimeFrame(string $deliveryTimeFrame): self
    {
        $this->deliveryTimeFrame = (string) (new _Enum\DeliveryTimeFrameEnum($deliveryTimeFrame));

        return $this;
    }

    public function setPreOrderDate(?string $preOrderDate): self
    {
        $this->preOrderDate = $preOrderDate;

        return $this;
    }

    public function setPreOrderPurchase(string $preOrderPurchase): self
    {
        $this->preOrderPurchase = (string) (new _Enum\PreOrderPurchaseEnum($preOrderPurchase));

        return $this;
    }

    public function setReorderItems(string $reorderItems): self
    {
        $this->reorderItems = (string) (new _Enum\ReorderItemsEnum($reorderItems));

        return $this;
    }

    public function setShippingMethod(string $shippingMethod): self
    {
        $this->shippingMethod = (string) (new _Enum\ShippingMethodEnum($shippingMethod));

        return $this;
    }

    public function setTransactionTypeId(string $transactionTypeId): self
    {
        $this->transactionTypeId = (string) (new _Enum\TransactionTypeEnum($transactionTypeId));

        return $this;
    }

    public function getChallenge(): string
    {
        return $this->challenge;
    }

    public function getDeliveryTimeFrame(): string
    {
        return $this->deliveryTimeFrame;
    }

    public function getPreOrderDate(): ?string
    {
        return $this->preOrderDate;
    }

    public function getPreOrderPurchase(): string
    {
        return $this->preOrderPurchase;
    }

    public function getReorderItems(): string
    {
        return $this->reorderItems;
    }

    public function getShippingMethod(): string
    {
        return $this->shippingMethod;
    }

    public function getTransactionTypeId(): string
    {
        return $this->transactionTypeId;
    }

    public function getName(): string
    {
        return 'riskValidation3ds2';
    }

    public function getDefaults(): array
    {
        return [
            self::CHALLENGE => (string) (new _Enum\ChallengeEnum()),
            self::DELIVERY_TIME_FRAME => (string) (new _Enum\DeliveryTimeFrameEnum()),
            self::PRE_ORDER_DATE => null,
            self::PRE_ORDER_PURCHASE => (string) (new _Enum\PreOrderPurchaseEnum()),
            self::REODER_ITEMS => (string) (new _Enum\ReorderItemsEnum()),
            self::SHIPPING_METHOD => (string) (new _Enum\ShippingMethodEnum()),
            self::TRANSACTION_TYPE_ID => (string) (new _Enum\TransactionTypeEnum()),
        ];
    }
}
