<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Response;

/**
 * Defines an interface for operation responses.
 */
interface OperationInterface
{
    public const STATUS_INITIATED = 'INITIATED';

    public const STATUS_PENDING = 'PENDING';

    public const STATUS_SUCCESS = 'SUCCESS';

    public const STATUS_FAIL = 'FAIL';

    public const STATUS_ERROR = 'ERROR';

    public const STATUS_VOIDED = 'VOIDED';

    public const STATUS_REBATED = 'REBATED';

    public const STATUS_NONE = 'N/A';

    public const STATUS_REJECTED = 'REJECTED';

    public const STATUS_GROUPED = 'GROUPED';

    public const STATUS_SUCCESS_WARNING = 'SUCCESS_WARNING';

    public const STATUS_REDIRECTED = 'REDIRECTED';

    public const STATUS_AWAITING_PAYSOL = 'AWAITING_PAYSOL';

    public const STATUS_PARTIAL_COMPLETED = 'PARTIAL_COMPLETED';

    public const STATUS_SUCCESS3DS = 'SUCCESS3DS';

    public const STATUS_ERROR3DS = 'ERROR3DS';

    public const STATUS_REVOKE_SUCCESS = 'REVOKE_SUCCESS';

    public const STATUS_TO_CAPTURE = 'TO_CAPTURE';

    public const STATUS_CANCELLED = 'CANCELLED';

    public const STATUS_PENDING_CONFIRMATION = 'PENDING_CONFIRMATION';

    public const RESPONSE_OPERATIONS_KEY = 'operations';

    public const RESPONSE_OPERATIONS_ARRAY_KEY = 'operationsArray';

    /**
     * Returns true if the operation can be considered a success.
     */
    public function hasSucceed(): bool;

    /**
     * Returns true if the operation has a pending/not-final status.
     */
    public function isPending(): bool;

    /**
     * Returns true if the operation was cancelled by the user.
     */
    public function isCancelled(): bool;

    /**
     * Returns true if the operation has error/failed status.
     */
    public function hasFailed(): bool;

    /**
     * Returns true if the operation needs to redirect the user.
     */
    public function needsRedirection(): bool;

    /**
     * Gets the redirection target if the operation needs to redirect the user, null otherwise.
     */
    public function getRedirectionTarget(): ?RedirectionTarget;

    /**
     * Returns the transactions covered by this operation.
     *
     * @return \ComerciaGlobalPayments\AddonPayments\SDK\Response\Transaction[]
     */
    public function getOperations(): array;

    /**
     * Get the transaction for single-transaction operations.
     *
     * If multiple always returns the first transaction.
     */
    public function getTransaction(): Transaction;

    /**
     * Gets the operation status.
     */
    public function getStatus(): ?string;
}
