<?php

declare(strict_types=1);

namespace ComerciaGlobalPayments\AddonPayments\SDK\Encryption\Cypher;

/**
 * Trait PaddedTextTrait.
 *
 * Provides padded text functionality.
 */
trait PaddedTextTrait
{
    public function getPaddedText(string $plainText, int $blockSize): string
    {
        $stringLength = \strlen($plainText);
        if ($stringLength % $blockSize) {
            $plainText = str_pad($plainText, $stringLength + $blockSize - $stringLength % $blockSize, "\0");
        }

        return $plainText;
    }
}
