<?php
/**
 * 2007-2021 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2021 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License
 *            (AFL 3.0) International Registered Trademark & Property of
 *            PrestaShop SA
 */
class CardToken extends ObjectModel
{
    public static $definition
        = [
            'table' => 'addonpayments_card_token',
            'primary' => 'id_token',
            'multilang' => false,
            'fields' => [
                'id_token' => ['type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'],
                'customer_id' => ['type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'],
                'accountId' => ['type' => self::TYPE_STRING, 'validate' => 'isString'],
                'paymentMethod' => ['type' => self::TYPE_STRING, 'validate' => 'isString'],
                'name' => ['type' => self::TYPE_STRING, 'validate' => 'isString'],
                'cardType' => ['type' => self::TYPE_STRING, 'validate' => 'isString'],
                'cardNumber' => ['type' => self::TYPE_STRING, 'validate' => 'isString'],
                'cardToken' => ['type' => self::TYPE_STRING, 'validate' => 'isString'],
                'rawData' => ['type' => self::TYPE_STRING],
                'createdAt' => ['type' => self::TYPE_DATE, 'validate' => 'isDate'],
                'lastUsed' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'required' => false],
            ],
        ];

    /** @var int */
    public $id_token;

    /** @var int */
    public $customer_id;

    /** @var string */
    public $accountId;

    /** @var string */
    public $paymentMethod;

    /** @var string */
    public $name;

    /** @var string */
    public $cardType;

    /** @var string */
    public $cardNumber;

    /** @var string */
    public $cardToken;

    /** @var object */
    public $rawData;

    /** @var string */
    public $createdAt;

    /** @var string */
    public $lastUsed;

    /**
     * Get registered payment methods for customer.
     *
     * @param int $customerId the customer identifier
     *
     * @return array|null
     *
     * @throws \PrestaShopDatabaseException
     */
    public static function getByCustomer($customerId)
    {
        $dbPrefix = _DB_PREFIX_;
        $sql = "SELECT
                `t`.`id_token`,
                `t`.`customer_id`,
                `t`.`accountId`,
                `t`.`paymentMethod`,
                `t`.`name`,
                `t`.`cardType`,
                `t`.`cardNumber`,
                `t`.`cardToken`,
                `t`.`rawData`,
                `t`.`createdAt`,
                `t`.`lastUsed`
            FROM `{$dbPrefix}addonpayments_card_token` t
            WHERE `t`.`customer_id` = {$customerId}";

        return Db::getInstance()->executeS($sql);
    }

    /**
     * Deletes a registered token using its EPG account ID.
     *
     * @param string $accountId
     *
     * @return bool
     */
    public static function deleteByAccountId(string $accountId): bool
    {
        return Db::getInstance()->delete('addonpayments_card_token', "accountId = '${accountId}'");
    }
}
